package fr.asip.cps3.exemple.modele.traitements.specifiques;

import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;

import java.util.LinkedHashMap;

import org.apache.log4j.Logger;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionProgrammeExemple;
import fr.asip.cps3.exemple.modele.exceptions.ExceptionTraitement;
import fr.asip.cps3.exemple.modele.jni.TraitementsSpecifiques;
import fr.asip.cps3.exemple.modele.resultats.Resultat;
import fr.asip.cps3.exemple.modele.resultats.ResultatSpecifiqueInfo;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;

/**
 * Classe de traitement spcifique: Modification d'objet de donnes applicatives
 *
 */
public class ModificationObjetDonneesApplicatives {

	/**
	 * Le loggeur
	 */
	private static Logger log = Logger.getLogger(ModificationObjetDonneesApplicatives.class);	
	
	/**
	 * Renvoie le rsultat du traitement
	 * @return Rsultat du traitement
	 * @throws ExceptionTraitement 
	 */
	public static Resultat traitement(TraitementsSpecifiques traitementsSpecifiques) throws ExceptionTraitement {
		
		try {
			
			if(traitementsSpecifiques != null) {
		
				ResultatSpecifiqueInfo resultat = new ResultatSpecifiqueInfo("Modification d'objet de donnes applicatives (jeton)");
				LinkedHashMap<String,String> infos = new LinkedHashMap<String,String>();
				resultat.setInfos(infos);

				try {
		
					// On essaie d'initialiser la librairie
					traitementsSpecifiques.initialiseLibrairie();
					
					// Traitement  tester
					byte[] valeur = traitementsSpecifiques.modificationObjetDonneesApplicatives();
					
					// Formatage du rsultat
					if(valeur != null) {
						
						try {

							infos.put("Valeur de l'attribut CKA_VALUE aprs relecture","\n"+TraitementsUtil.getHexadecimal(valeur,16));
							
						} catch(ClassCastException e) {
							
							// Si une erreur de cast survient on lve l'exception
							log.error("Erreur de cast : "+e.getMessage());
							throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SPECIFIQUE_MODIFICATION_OBJET, "Une erreur inattendue est survenue");
							
						}
					}
					
					// Formatage du rsultat
					resultat.setRetour("Modification du jeton ralise avec succs (0x00000000)");
					
				} catch (PKCS11Exception e) {

					log.info("Traitement echoue : "+TraitementsUtil.retranscritCodeRetour(e.getErrorCode()));
					resultat.setCodeRetour(e.getErrorCode());

				}
				
				return resultat;
				
			} else {
				
				// Si l'interface des traitements spcifiques est nulle il est impossible de raliser le traitement
				log.error("La librairie est nulle");
				throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SPECIFIQUE_MODIFICATION_OBJET, "L'interface des traitements spcifiques est nulle");
				
			}

		} catch (Throwable t) {
			
			// Si une erreur Traitement a t rencontre on lve l'exception
			if(t instanceof ExceptionTraitement)
				throw (ExceptionTraitement)t;
			
			// Si une erreur inattendue est survenue on la logue et on la lve
			log.error("Une erreur inattendue est survenue : "+ExceptionProgrammeExemple.getStacktrace(t));
			throw new ExceptionTraitement(ExceptionProgrammeExemple.TYPE_TRAITEMENT_SPECIFIQUE_MODIFICATION_OBJET, "Une erreur inattendue est survenue");
			
		}

	}
	
}
